// lib/auth_util.js (ES module)

// 允许直接输入完整邮箱（包含@），否则拼接后缀
export function buildEmail(userInput, ext) {
  const user = (userInput || "").trim();
  const suffix = ext || "";
  if (!user) return "";
  if (user.includes("@")) return user;
  return user + suffix;
}

// 兼容 urlsafe base64：- _ 以及缺少 padding
export function decodeBase64ToJson(b64) {
  if (!b64 || typeof b64 !== "string") return null;

  let s = b64.replace(/-/g, "+").replace(/_/g, "/");
  while (s.length % 4 !== 0) s += "=";

  try {
    return JSON.parse(atob(s));
  } catch {
    return null;
  }
}

/**
 * 兼容：
 * 1) payload.data = base64(JSON string)
 * 2) payload.data = object
 */
export function normalizePayloadData(payload) {
  if (!payload) return null;
  if (typeof payload.data === "string") return decodeBase64ToJson(payload.data);
  if (typeof payload.data === "object" && payload.data) return payload.data;
  return null;
}

export function vipText(vip) {
  const v = String(vip ?? "0");
  if (v === "0") return "普通用户";
  return `VIP${v}`;
}

// 通用表单 POST（x-www-form-urlencoded）
export async function postForm(url, data) {
  const body = new URLSearchParams(data).toString();
  const resp = await fetch(url, {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body
  });

  const text = await resp.text();
  try {
    return { ok: resp.ok, json: JSON.parse(text), raw: text };
  } catch {
    return { ok: resp.ok, json: null, raw: text };
  }
}
